<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage core
* @filesource
*//** */


/**
* Allows the application to customize the database drivers.
*
* Database drivers may be overriden or extended by placing a file named MY_driver_name.php in APPPATH/database (replace MY_ with your value for $config['subclass_prefix']).
*
* @package direct-as-a-service
* @subpackage core
*/
class DPII_Loader extends CI_Loader{
	
	/**
     * Database Loader
	 *
 	 * This method was only slightly modified from the method suggested by Ellis Labs: {@link https://github.com/EllisLab/CodeIgniter/wiki/Extending-Database-Drivers Extending Database Drivers}.
     *
     * @param    string    the DB credentials
     * @param    bool    whether to return the DB object
     * @param    bool    whether to enable active record (this allows us to override the config setting)
	 * @return   CI_DB
     */
    public function database($params = '', $return = FALSE, $active_record = NULL)
    {
        // Grab the super object
        $CI =& get_instance();
 
        // Do we even need to load the database class?
        if (class_exists('CI_DB') AND $return == FALSE AND $active_record == NULL AND isset($CI->db) AND is_object($CI->db))
        {
            return FALSE;
        }
 
        require_once(BASEPATH.'database/DB'.EXT);
		$db = DB($params, $active_record);
 
		$my_driver = config_item('subclass_prefix').'DB_'.$db->dbdriver.'_driver';
		$my_driver_file = APPPATH.'database/'.$my_driver.EXT;

		if (file_exists($my_driver_file))
		{
			require_once($my_driver_file);
			$default_values = get_object_vars($db); //Ellis Labs suggest you do this to get the configuration that DB() provides
			$default_values['_escape_char'] = '['; //except they unhelpfully initialized variables to empty instead leaving them null, so we have no way of knowing if an _escape_char value was provided or not.  We'll default to what we want it to be.
			$db = new $my_driver($default_values);
		}

		if ($return === TRUE)
		{	
			return $db;
		}
 
        // Initialize the db variable.  Needed to prevent
        // reference errors with some configurations
        $CI->db = '';
 
        // Load the DB class
		if(file_exists($my_driver_file)){
			$CI->db = new $my_driver(get_object_vars($db));
		}else
	        $CI->db =& DB($params, $active_record);
    }
	
	//overrides parent disallow loading entity models
	public function model($model, $name = '', $db_conn = FALSE){
		
		if(empty($model) || is_array($model)) return parent::model($model, $name, $db_conn);
		
		
		$path = '';
 
        // Is the model in a sub-folder? If so, parse out the filename and path.
        if (($last_slash = mb_strrpos($model, '/')) !== FALSE)
        {
            // The path is in front of the last slash
            $path = mb_substr($model, 0, $last_slash + 1);
 
            // And the model name behind it
            $model = mb_substr($model, $last_slash + 1);
        }
		
		//check to see if this is an entity - if so, it shouldn't be loaded.  
		//entity models follow a different design pattern - instances are meant to represent a record in the database.  any methods that deal with more than one record should be static.
		foreach ($this->_ci_model_paths as $mod_path){
			if(file_exists($mod_path.'models/'.$path.$model.'.php')){
				require_once $mod_path.'models/'.$path.$model.'.php';
				if(class_exists($model) && is_subclass_of($model, 'Entity')){
					return get_instance()->error->warning( $model.' is an entity model and should not be loaded using the CI loader.  To bring the class into scope, use the standard PHP include_once() or require_once()');
				}
			}
		}
		
		return parent::model($model, $name, $db_conn);
    }	

	
	
}